import { transform } from "@/lib/transformers";
import { AppStatewideServices } from "../type/services";
import { AmplifyStatewideServicesListResult } from "./actions";

export function transformStatewideServices(services: AppStatewideServices) {
  return transform(
    services,
    (service) => ({
      id: service.id,
      agencyId: service.agencyid,
      message: service.message,
      url: service.url,
      phone: service.phone,
      alias: service.alias,
    })
  )
}

export function transformStatewideServicesResult(result: AmplifyStatewideServicesListResult) {
  return transform(
    result.data,
    (service) => ({
      id: service.id,
      agencyId: service.agencyid,
      message: service.message,
      url: service.url,
      phone: service.phone,
      alias: service.alias,
    })
  )
}

